﻿using System;
using System.Collections;
using System.Workflow.Activities;
using System.Workflow.ComponentModel;
using Microsoft.SharePoint;
using Microsoft.SharePoint.Workflow;

namespace AngebotWorkflow.Workflow1
{
   public sealed partial class Workflow1 : SequentialWorkflowActivity
   {
      public Workflow1()
      {
         InitializeComponent();
      }

      public Guid workflowId = default(System.Guid);
      public SPWorkflowActivationProperties workflowProperties = new SPWorkflowActivationProperties();
      public Guid createTask_TaskId = default(System.Guid);
      public SPWorkflowTaskProperties createTask_TaskProperties = new SPWorkflowTaskProperties();
      public SPWorkflowTaskProperties taskChanged_AfterProperties = new SPWorkflowTaskProperties();
      public string WorkflowResult;
      private bool isFinished = false;

      private void ExecuteEnsureTaskContentType(object sender, EventArgs e)
      {
         // den Inhaltstypen zur Aufgabenliste hinzufügen, wenn er nicht schon registriert ist
         SPSecurity.RunWithElevatedPrivileges(delegate()
                     {
                        AddContentTypeToTaskList();
                     });
      }

      private void AddContentTypeToTaskList()
      {
         // eine neue Referenz auf die Objekte herstellen
         using (var site = new SPSite(workflowProperties.Web.Url))
         {
            SPWeb web = site.OpenWeb();
            SPList taskList = web.Lists[workflowProperties.TaskListId];

            string contentType = createTask.ContentTypeId;
            var contentTypeId = new SPContentTypeId(contentType);
            taskList.ContentTypesEnabled = true;
            SPContentTypeId matchContentTypeId = taskList.ContentTypes.BestMatch(contentTypeId);
            if (matchContentTypeId.Parent.CompareTo(contentTypeId) != 0)
            {
               SPContentType ct = taskList.ParentWeb.AvailableContentTypes[contentTypeId];
               if (ct == null) return;
               taskList.ContentTypes.Add(ct);
               taskList.Update();
            }
         }
      }

      private void ExecuteCreateTask(object sender, EventArgs e)
      {
         // Generierung einer Aufgaben Id
         createTask_TaskId = Guid.NewGuid();
         // Zuweisung von einigen Eigenschaften der Aufgabe
         createTask_TaskProperties.AssignedTo = workflowProperties.Originator;
         createTask_TaskProperties.Title = "Neues Angebot :" + workflowProperties.Item.Title;
         createTask_TaskProperties.StartDate = DateTime.Today;
         createTask_TaskProperties.DueDate = DateTime.Today.AddDays(2);
      }

      private void notFinished(object sender, ConditionalEventArgs e)
      {
         e.Result = !isFinished;
      }

      private void ExecuteTaskChanged(object sender, ExternalDataEventArgs e)
      {
         SPFieldCollection fields = workflowProperties.TaskList.Fields;
         var kundennameId = fields.GetFieldByInternalName("Kundenname").Id;
         var angebotspreisId = fields.GetFieldByInternalName("Angebotspreis").Id;
         //Hashtable properties = createTask_TaskProperties.ExtendedProperties;
         Hashtable properties = taskChanged_AfterProperties.ExtendedProperties;
         var kundenname = properties[kundennameId] as string;

         decimal angebotspreis;
         decimal.TryParse(properties[angebotspreisId] as string, out angebotspreis);

         WorkflowResult = string.Format("Der Kunde ist '{0}', die Angebotssumme {1}€", kundenname, angebotspreis);

         isFinished = true;
      }

      protected override ActivityExecutionStatus HandleFault(ActivityExecutionContext executionContext, Exception ex)
      {
         var sharePointService = ((ISharePointService)executionContext.GetService(typeof(ISharePointService)));
         sharePointService.LogToHistoryList(WorkflowInstanceId, SPWorkflowHistoryEventType.WorkflowComment, 0, TimeSpan.MinValue, ex.Message, ex.StackTrace, string.Empty);
         return ActivityExecutionStatus.Closed;
      }
   }
}
